<?php
/**
 * Avalanche for Magento 1.8+
 * Designed by Fast Division (http://fastdivision.com)
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://fastdivision.com/legal/license.txt
 *
 * @author     Fast Division
 * @version    1.5.0
 * @copyright  Copyright 2013 Fast Division
 * @license    http://fastdivision.com/legal/license.txt
 */
 
class FastDivision_Mobile_Helper_Data extends Mage_Core_Helper_Abstract
{
    const DEFAULT_PACKAGE = 'avalanche';
    const DEFAULT_THEME = 'mobile';

    protected $_targetPlatform = null;     

    public function getShowDesktop()
    {
        return Mage::getModel('core/cookie')->get('showDesktop');
    }

    public function setStateChanged()
    {
        Mage::getModel('core/cookie')->set('stateChanged', true);
    }

    public function setForced()
    {
        Mage::getModel('core/cookie')->set('forced', true);
        return $this;
    }

    public function checkForcedDesktop()
    {
        return Mage::getModel('core/cookie')->get('forced');
    }
    
    public function setShowDesktop($value)
    {
        $this->setStateChanged();
        $this->setForced();
        Mage::getModel('core/cookie')->set('showDesktop', $value);
    }

    public function getTargetPlatform()
    {
        // Validate Package
        $package = Mage::getStoreConfig('design/package/name', Mage::app()->getStore()->getStoreId());
        if($package != "avalanche") {
            return 'desktop';
        }

        if($this->checkDisableOutput()) {
            return 'desktop';
        }
        
        if(!$this->_targetPlatform) {
            $targetPlatform = 'desktop';

            if(isset($_SERVER['HTTP_USER_AGENT'])) {
                if(strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone') || strpos($_SERVER['HTTP_USER_AGENT'], 'Android')) {
                    $targetPlatform = 'mobile';
                }
            } else {
                $targetPlatform = 'desktop';
            }

            if($this->checkForcedDesktop()) {
                $targetPlatform = $this->getShowDesktop() ? 'desktop' : 'mobile';
            }

            $this->_targetPlatform = $targetPlatform;
        }

        return $this->_targetPlatform;
    }

    public function checkDisableOutput()
    {
        return !!Mage::getStoreConfig('advanced/modules_disable_output/FastDivision_Mobile');
    }

    public function getResizedImageName($imageName, $dimensions)
    {
        $imageExt = substr(strrchr($imageName, '.'), 1);
        return str_replace('.' . $imageExt, '_' . $dimensions . '.' . $imageExt, $imageName);
    }

    public function getStoreStyle()
    {
        $style = Mage::getStoreConfig('avalanche_mobile/design/css_path', Mage::app()->getStore()->getStoreId());
        if(!empty($style)) {
            return Mage::getDesign()->getSkinUrl('css/' . $style);
        } else {
            return Mage::getDesign()->getSkinUrl('css/style.css');
        }
    }
}
